<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tracks()
    {
        return $this->hasMany('Track');
    }

    public function location()
    {
        return $this->belongsTo('Location');
    }

}